﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using RevisionAnalyser.Global;
using RevisionAnalyser.Projects;

namespace RevisionAnalyser
{
    public partial class PluginsForm : Form
    {
        private Dictionary<string, string> pluginInfo = new Dictionary<string, string>();

        public PluginsForm()
        {
            InitializeComponent();
        }

        private void PluginsForm_Load(object sender, EventArgs e)
        {
            List<ProjectType> types = ProjectTypes.Instance.GetProjectTypes();
            foreach (ProjectType type in types)
            {
                string info = String.Format("Name:{0}{1}{0}{0}Description:{0}{2}{0}{0}Copyright:{0}{3}{0}{0}Version:{0}{4}", "\r\n", type.Name, type.Description, type.Copyright, type.Version);
                pluginInfo.Add(type.Name, info);
                uxPluginsField.Items.Add(type.Name);
            }
            if (uxPluginsField.Items.Count > 0)
            {
                uxPluginsField.SelectedIndex = 0;
            }
        }

        private void uxPluginsField_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                uxInfoField.Text = pluginInfo[(string)uxPluginsField.SelectedItem];
            }
            catch
            {
            }
        }

        private void uxCloseButton_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}
